<?php echo e(View::make('layout.header')); ?>

<?php
    
    $user_join_year = date('Y', strtotime(App\Models\UserPay::where('username', Auth::user()->username)->first()->date_commence));
    $cutOffStartMonth = getSettingsValue('cut_of_startmonth');
    
    if ($cutOffStartMonth != 1) {
        if ($cutOffStartMonth > date('m')) {
            $currentYear = date('Y') + 1;
        } else {
            $currentYear = date('Y') + 1;
        }
    } else {
        $currentYear = date('Y') + 1;
    }
?>
<style>
    .timeline .timeline-item .timeline-event h6 {
        word-break: break-all
    }

    .table tbody td,
    .table thead th {
        padding-left: 6px !important;
        padding-right: 6px !important
    }

    table.dataTable thead .sorting:after,
    table.dataTable thead .sorting:before,
    table.dataTable thead .sorting_asc:after,
    table.dataTable thead .sorting_asc:before,
    table.dataTable thead .sorting_desc:after,
    table.dataTable thead .sorting_desc:before {
        display: none
    }

    #start_year {
        -webkit-appearance: none !important;
        padding-right: 3.5rem;
    }
</style>
<!-- BEGIN: Content-->

<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0">E-Attendance</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">Employee
                                </li>
                                <li class="breadcrumb-item active"><a href="<?php echo e(route('dashboardEmp')); ?>">Dashboard</a>
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="dashboard-ecommerce">
                <div class="row match-height">
                    <!-- Statistics Card -->
                    <div class="col-xl-12 col-md-12 col-12">
                        <div class="card card-statistics" style="flex: 0;">
                            <div class="card-header">
                                <h4 class="card-title">E-Attendance</h4>
                                <form id="filter-form">
                                    <div class="d-sm-flex justify-content-between align-items-center">
                                        <div class="d-flex align-items-center">

                                            <?php echo csrf_field(); ?>
                                            <select onchange="dataYear(this.value)" class="form-control" id="data_year"
                                                name="data_year" style="border-width: 0px;">
                                                <?php
                                                $start_year = getSettingsValue("software_start_year");
                                                $SoftwareStartDate = $start_year;
                                                if($user_join_year>$SoftwareStartDate){
                                                    
                                                    $start_year = $user_join_year;
                                                }
                                                for($i= $start_year; $i<=$currentYear; $i++){
                                                ?>
                                                <option <?php if($i == date('Y')): ?> selected <?php endif; ?>
                                                    value="<?php echo e($i); ?>">
                                                    <?php echo $i; ?>
                                                </option>
                                                <?php }
                                            
                                            ?>
                                            </select>

                                            <select onchange="fromMonth(this.value)" class="form-control"
                                                id="from_month" name="month" style="border-width: 0px;">

                                                <?php
                                                
                                                for ($i = 1; $i <= 12; $i++) {
                                                    $monthNum = $i;
                                                    $dateObj = DateTime::createFromFormat('!m', $monthNum);
                                                    $label = $dateObj->format('F');
                                                
                                                    $value = $i;
                                                    if (date('n') == $i) {
                                                        echo "<option selected value='$value'>$label</option>";
                                                    } else {
                                                        echo "<option value='$value'>$label</option>";
                                                    }
                                                }
                                                
                                                ?>
                                            </select>
                                            -
                                            <select onchange="toMonth(this.value)" class="form-control" id="to_month"
                                                name="month" style="border-width: 0px;">

                                                <?php
                                                
                                                for ($i = 1; $i <= 12; $i++) {
                                                    $monthNum = $i;
                                                    $dateObj = DateTime::createFromFormat('!m', $monthNum);
                                                    $label = $dateObj->format('F');
                                                
                                                    $value = $i;
                                                    if (date('n') == $i) {
                                                        echo "<option selected value='$value'>$label</option>";
                                                    } else {
                                                        echo "<option value='$value'>$label</option>";
                                                    }
                                                }
                                                
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <div class="card-body statistics-body">
                                <div class="row">
                                    <div class="col-xl-3 col-sm-6 col-12 mb-2 mb-xl-0">
                                        <div class="media">
                                            <div class="avatar bg-light-primary mr-2" style="cursor:unset;">
                                                <div class="avatar-content">
                                                    <img src="<?php echo e(asset('app-assets/svg/edit-emp.svg')); ?>"
                                                        class="avatar-icon" style="height: 56%; width:100%;">
                                                </div>
                                            </div>
                                            <div class="media-body my-auto">
                                                <h4 class="font-weight-bolder mb-0"><span id="workday"></span></h4>
                                                <p class="card-text font-small-3 mb-0">Workday</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-sm-6 col-12 mb-2 mb-xl-0">
                                        <div class="media">
                                            <div class="avatar bg-light-info mr-2" style="cursor:unset;">
                                                <div class="avatar-content">
                                                    <img src="<?php echo e(asset('app-assets/svg/assign-schedule-to-employee.svg')); ?>"
                                                        class="avatar-icon" style="height: 56%; width:100%;">
                                                </div>
                                            </div>
                                            <div class="media-body my-auto">
                                                <h4 class="font-weight-bolder mb-0"><span id="ot"></h4>
                                                <p class="card-text font-small-3 mb-0">Overtime</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-sm-6 col-12 mb-2 mb-sm-0">
                                        <div class="media">
                                            <div class="avatar bg-light-danger mr-2" style="cursor:unset;">
                                                <div class="avatar-content">
                                                    <img src=" <?php echo e(asset('app-assets/svg/absend_emp.svg')); ?>"
                                                        class="avatar-icon" style="height: 56%; width:100%;">
                                                </div>
                                            </div>
                                            <div class="media-body my-auto">
                                                <h4 class="font-weight-bolder mb-0"><span id="lateness"></span></h4>
                                                <p class="card-text font-small-3 mb-0">Lateness</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-sm-6 col-12 mb-2 mb-sm-0">
                                        <div class="media">
                                            <div class="avatar bg-light-warning mr-2" style="cursor:unset;">
                                                <div class="avatar-content">
                                                    <img src=" <?php echo e(asset('app-assets/svg/late-emp.svg')); ?>"
                                                        class="avatar-icon">
                                                </div>
                                            </div>
                                            <div class="media-body my-auto">
                                                <h4 class="font-weight-bolder mb-0"><span id="early_dep"></span></h4>
                                                <p class="card-text font-small-3 mb-0">Early Departure</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card card-statistics" style="flex: 0;">
                            <div class="card-header">
                                <h4 class="card-title">My Leaves</h4>
                                <form id="filter-form">
                                    <div class="d-sm-flex justify-content-between align-items-center">
                                        <div class="d-flex align-items-center">

                                            <?php echo csrf_field(); ?>
                                            <select class="form-control" id="start_year" name="year"
                                                style="border-width: 0px;" onchange="year_filter(this.value)">
                                                <?php
                                                $start_year = getSettingsValue("software_start_year");
                                                $SoftwareStartDate = $start_year;
                                                if($user_join_year>$SoftwareStartDate){
                                                    
                                                    $start_year = $user_join_year;
                                                }
                                                for($i= $start_year; $i<=$currentYear; $i++){
                                                ?>
                                                <option value="<?php echo e($i); ?>">
                                                    <?php echo $i; ?>
                                                </option>
                                                <?php }
                                            
                                            ?>
                                            </select>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <div class="card-body statistics-body">
                                <div class="row">
                                    <canvas id="canvas" height="280" width="600"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>

                    <input type="hidden" id="userdata">
                </div>


            </section>
        </div>
    </div>
</div>

<!-- END: Content-->
<?php echo e(View::make('layout.footer')); ?>

<?php echo $__env->make('inc.timline-model', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script type="text/javascript">
    var month = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];

    var current_year = new Date().getFullYear();
    var current_month = new Date().getMonth() + 1;
    $(document).ready(function() {

        $('#start_year option[value="' + current_year + '"]').attr("selected", true);
        var data = getdata(current_month, current_year, 'today', 'counter');
        $('#workday').text(data.present_emp);
        $('#ot').text(data.overtime);
        $('#lateness').text(data.lateness);
        $('#early_dep').text(data.early_dep);

    });

    document.addEventListener('readystatechange', event => {
        if (event.target.readyState === "complete") {
            year_filter(current_year);
        }
    });


    // emp data filtration start
    function dataYear(current_year) {
        var fromMonth = $("#from_month").val();
        var toMonth = $("#to_month").val();

        var data = getAttdata(fromMonth, toMonth, current_year);
        $('#workday').text(data.present_emp);
        $('#ot').text(data.overtime);
        $('#lateness').text(data.lateness);
        $('#early_dep').text(data.early_dep);
    }

    function fromMonth(fromMonth) {
        var current_year = $("#data_year").val();
        var toMonth = $("#to_month").val();

        var data = getAttdata(fromMonth, toMonth, current_year);
        $('#workday').text(data.present_emp);
        $('#ot').text(data.overtime);
        $('#lateness').text(data.lateness);
        $('#early_dep').text(data.early_dep);
    }

    function toMonth(toMonth) {
        var current_year = $("#data_year").val();
        var fromMonth = $("#from_month").val();

        var data = getAttdata(fromMonth, toMonth, current_year);
        $('#workday').text(data.present_emp);
        $('#ot').text(data.overtime);
        $('#lateness').text(data.lateness);
        $('#early_dep').text(data.early_dep);
    }

    var userdata = '';

    function getAttdata(from_month, to_month, year, chartype = "yearwise") {

        $.ajax({
            type: 'GET',
            async: false,
            url: '<?php echo e(route('empdashboarddata')); ?>',
            data: {
                'month': from_month,
                'to_month': to_month,
                'year': year,
                'user_type': 'emp',
                'emp_no': '<?php echo getEmpNo(); ?>',
                'chartype': chartype
            },
            success: function(data) {
                userdata = data;
            }
        });
        return userdata;
    }
    // emp data filtration end

    function getdata(month, year, chartype = 'yearwise', type) {
        $.ajax({
            type: 'GET',
            async: false,
            url: '<?php echo e(route('empdashboarddata')); ?>',
            data: {
                'month': month,
                'year': year,
                'user_type': 'emp',
                'emp_no': '<?php echo getEmpNo(); ?>',
                'chartype': chartype,
                'dataType': type
            },
            success: function(data) {
                userdata = data;
            }
        });
        return userdata;
    }

    // ************ start_year ************



    // charts 
    var Present = [];
    var Absent = [];
    var Late = [];
    var ot_emp = [];
    var chartdata = [];
    var barChartData;


    function year_filter(value) {
        var start_year = value;
        var yearData = getdata(1, start_year, '', 'bar');

        $.each(yearData, function(key, val) {
            Present.push(val.present_emp);
            Absent.push(val.total_absent);
            Late.push(val.late_emp);
            ot_emp.push(val.overtimes_emp);
        });


        chartdata = [{
                label: 'Present',
                backgroundColor: "#28c76f",
                data: Present
            },
            {
                label: 'Absent',
                backgroundColor: "#FF0000",
                data: Absent
            },
            {
                label: 'Late',
                backgroundColor: "#FFFF00",
                data: Late
            },
            {
                label: 'OT',
                backgroundColor: "#A3498B",
                data: ot_emp
            }
        ];

        BarCharData(chartdata);
        CreateChart();
        Present = [];
        Absent = [];
        Late = [];
        ot_emp = [];
        chartdata = [];

    }


    function BarCharData(chartdata) {
        barChartData = {
            labels: month,
            datasets: chartdata
        };
    }




    function CreateChart() {
        var ctx = document.getElementById("canvas");
        window.myBar = new Chart(ctx, {
            type: 'bar',
            data: barChartData,
            options: {
                responsive: true,
                scales: {
                    yAxes: [{
                        display: true,
                        ticks: {
                            beginAtZero: true,
                            steps: 10,
                            stepValue: 5,
                            max: 35
                        }
                    }]
                }
            }
        });
    };
</script>
<?php /**PATH /home/ecoleave/public_html/v4/armada/resources/views/E-Attendance/dashboard_em.blade.php ENDPATH**/ ?>