<?php echo e(View::make('layout.header')); ?>

    <!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">E-Leave</h2>
                            <div class="breadcrumb-wrapper">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">Employee
                                    </li>
                                    <li class="breadcrumb-item active"><a href="#">Self Leave</a>
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-body">
                <!-- Dashboard Ecommerce Starts -->
                <section id="dashboard-ecommerce">
                    <div class="row match-height">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="table-responsive" style="padding: 0 15px 15px 15px;">
                                        <div class="d-sm-flex justify-content-between align-items-center" style="margin: 20px 0;">
                                            <h4 class="card-title mb-50 mb-sm-0">My Leaves</h4>
                                            <div class="d-flex align-items-center">
                                                <div class="btn-group" style="padding-left: 10px;">
                                                    <button class="btn btn-flat-primary dropdown-toggle waves-effect" type="button" id="dropdownMenuButton100" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                        All Leave Types  
                                                    </button>
                                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton100" style="">
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 1</a>
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 2</a>
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 3</a>
                                                    </div>
                                                </div> |
                                                <div class="btn-group" style="padding-left: 10px;">
                                                    <button class="btn btn-flat-primary dropdown-toggle waves-effect" type="button" id="dropdownMenuButton100" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                        Jan 2021 
                                                    </button>
                                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton100" style="">
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 1</a>
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 2</a>
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 3</a>
                                                    </div>
                                                </div> To
                                                <div class="btn-group" style="padding-left: 10px;">
                                                    <button class="btn btn-flat-primary dropdown-toggle waves-effect" type="button" id="dropdownMenuButton100" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                        Dec 2021
                                                    </button>
                                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton100" style="">
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 1</a>
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 2</a>
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 3</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>TYPE</th>
                                                <th>RELIEVE</th>
                                                <th>DAY APPLY</th>
                                                <th>LEAVE DATE</th>
                                                <th>DAYS</th>
                                                <th>LEAVE REASON</th>
                                                <th>CANCELLATION REASON</th>
                                                <th>REJECT REASON</th>
                                                <th width="20%">STATUS</th>
                                                <th>ACTION</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $leaves; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $leave): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <?php
                                                    $r_name = '';
                                                    if($leave->relieve != '')
                                                    {
                                                        $employee = Illuminate\Support\Facades\DB::table('user_personal')
                                                        ->where('username', $leave->relieve)->first();
                                                        $r_name = $employee->name;
                                                    }

                                                    $status = '';
                                                    $class= '';

                                                    if($leave->status == 0)
                                                    {
                                                        $status = 'Pending';
                                                        $class= 'grey';
                                                    }
                                                    elseif($leave->status == 1)
                                                    {
                                                        $status = 'Approved';
                                                        $class= 'green';
                                                    }
                                                    elseif($leave->status == 2)
                                                    {
                                                        $status = 'Rejected';
                                                        $class= 'red';
                                                    }
                                                    elseif($leave->status == 3)
                                                    {
                                                        $status = 'Recommended';
                                                        $class= 'blue';
                                                    }
                                                    elseif($leave->status == 4)
                                                    {
                                                        $status = 'Cancelled';
                                                        $class= 'yellow';
                                                    }
                                                    elseif($leave->status == 5)
                                                    {
                                                        $status = 'Cancellation Pending';
                                                        $class= 'orange';
                                                    }
                                                    
                                                ?>
                                                <td><?php echo e($leave->type); ?></td>
                                                <td><?php echo e($r_name); ?></td>
                                                <td><?php echo e(date('Y-m-d', strtotime($leave->date_applied))); ?></td>
                                                <td><?php echo e($leave->start_date); ?></td>
                                                <td><?php echo e($leave->no_days); ?></td>
                                                <td></td>
                                                <td></td>
                                                <td><?php echo e($leave->reason); ?></td>
                                                <td style="background-color:<?php echo e($class); ?>;color:black;"><?php echo e($status); ?></td>
                                                <td><button type="button" class="btn btn-outline-dark waves-effect">Cancel</button></td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                    <div style="float: right;">
                                        <?php echo e($leaves->links('pagination::bootstrap-4')); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row match-height">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="table-responsive" style="padding: 0 15px 15px 15px;">
                                        <div class="d-sm-flex justify-content-between align-items-center" style="margin: 20px 0;">
                                            <h4 class="card-title mb-50 mb-sm-0">Leave Summary</h4>
                                            <div class="d-flex align-items-center">
                                                <div class="btn-group" style="padding-left: 10px;">
                                                    <button class="btn btn-flat-primary dropdown-toggle waves-effect" type="button" id="dropdownMenuButton100" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                        All Leave Types  
                                                    </button>
                                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton100" style="">
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 1</a>
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 2</a>
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 3</a>
                                                    </div>
                                                </div> |
                                                <div class="btn-group" style="padding-left: 10px;">
                                                    <button class="btn btn-flat-primary dropdown-toggle waves-effect" type="button" id="dropdownMenuButton100" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                        Jan 2021 
                                                    </button>
                                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton100" style="">
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 1</a>
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 2</a>
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 3</a>
                                                    </div>
                                                </div> To
                                                <div class="btn-group" style="padding-left: 10px;">
                                                    <button class="btn btn-flat-primary dropdown-toggle waves-effect" type="button" id="dropdownMenuButton100" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                        Dec 2021
                                                    </button>
                                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton100" style="">
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 1</a>
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 2</a>
                                                        <a class="dropdown-item" href="javascript:void(0);">Type 3</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>TYPE</th>
                                                <th>BF</th>
                                                <th>BF ADJ</th>
                                                <th>ENTITLE</th>
                                                <th>EARN</th>
                                                <th>CLAIMABLE</th>
                                                <th>NPL</th>
                                                <th>TAKEN</th>
                                                <th>FORFEIT</th>
                                                <th>BALANCE</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>Annual</td>
                                                <td>0</td>
                                                 <td>0</td>
                                                <td>20</td>
                                                <td>6.5</td>
                                                <td>20</td>
                                                <td>0</td>
                                                <td>O(EL)|O(AL)</td>
                                                <td>O(BF)|O(AD)</td>
                                                <td>20</td>
                                            </tr>
                                          <tr>
                                                <td>Annual</td>
                                                <td>0</td>
                                                 <td>0</td>
                                                <td>20</td>
                                                <td>6.5</td>
                                                <td>20</td>
                                                <td>0</td>
                                                <td>O(EL)|O(AL)</td>
                                                <td>O(BF)|O(AD)</td>
                                                <td>20</td>
                                            </tr>
                                            <tr>
                                                <td>Annual</td>
                                                <td>0</td>
                                                 <td>0</td>
                                                <td>20</td>
                                                <td>6.5</td>
                                                <td>20</td>
                                                <td>0</td>
                                                <td>O(EL)|O(AL)</td>
                                                <td>O(BF)|O(AD)</td>
                                                <td>20</td>
                                            </tr>
                                            <tr>
                                                <td>Annual</td>
                                                <td>0</td>
                                                 <td>0</td>
                                                <td>20</td>
                                                <td>6.5</td>
                                                <td>20</td>
                                                <td>0</td>
                                                <td>O(EL)|O(AL)</td>
                                                <td>O(BF)|O(AD)</td>
                                                <td>20</td>
                                            </tr>
                                            <tr>
                                                <td>Annual</td>
                                                <td>0</td>
                                                 <td>0</td>
                                                <td>20</td>
                                                <td>6.5</td>
                                                <td>20</td>
                                                <td>0</td>
                                                <td>O(EL)|O(AL)</td>
                                                <td>O(BF)|O(AD)</td>
                                                <td>20</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <div style="float: right;">
                                        <nav aria-label="Page navigation example">
                                            <ul class="pagination mt-2">
                                              <li class="page-item prev-item"><a class="page-link" href="javascript:void(0);"></a></li>
                                              <li class="page-item"><a class="page-link" href="javascript:void(0);">1</a></li>
                                              <li class="page-item"><a class="page-link" href="javascript:void(0);">2</a></li>
                                              <li class="page-item"><a class="page-link" href="javascript:void(0);">3</a></li>
                                              <li class="page-item active" aria-current="page">
                                                <a class="page-link" href="javascript:void(0);">4</a>
                                              </li>
                                              <li class="page-item"><a class="page-link" href="javascript:void(0);">5</a></li>
                                              <li class="page-item"><a class="page-link" href="javascript:void(0);">6</a></li>
                                              <li class="page-item"><a class="page-link" href="javascript:void(0);">7</a></li>
                                              <li class="page-item next-item"><a class="page-link" href="javascript:void(0);"></a></li>
                                            </ul>
                                          </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
    <!-- END: Content-->
    <?php echo e(View::make('layout.footer')); ?>

    <script type="text/javascript">
        function showenddate() {
            document.getElementById('end_date').style.display='block';
        }
        function hideenddate() {
            document.getElementById('end_date').style.display='none';
        }

        function saveDetails(e){
            var leaveForm = $("#leave-form");
            var data = leaveForm.serialize();
            $( '#type-error' ).html('');
            $( '#day-error' ).html('');
            $( '#start-date-error' ).html('');
            $( '#end-date-error' ).html('');
            $( '#relive-error' ).html('');
            $( '#reason-error' ).html('');
            $.ajax({
                url:'<?php echo e(route('myleave-apply')); ?>',
                type:'POST',
                data:data,
                success:function(e){
                    
                },
                error:function(w){
                    if(w.responseJSON.errors)
                    {
                        if(w.responseJSON.errors.leave_type){
                            $( '#type-error' ).html( w.responseJSON.errors.leave_type[0] );
                        }
                        if(w.responseJSON.errors.hof){
                            $( '#day-error' ).html( w.responseJSON.errors.hof[0] );
                        }
                        if(w.responseJSON.errors.leave_start_date){
                            $( '#start-date-error' ).html( w.responseJSON.errors.leave_start_date[0] );
                        }
                        if(w.responseJSON.errors.leave_end_date){
                            $( '#end-date-error' ).html( w.responseJSON.errors.leave_end_date[0] );
                        }
                        if(w.responseJSON.errors.reason){
                            $( '#reason-error' ).html( w.responseJSON.errors.reason[0] );
                        }
                        if(w.responseJSON.errors.relieve){
                            $( '#relive-error' ).html( w.responseJSON.errors.relieve[0] );
                        }

                    }
                }
            });
            

        };
    </script><?php /**PATH C:\xampp\htdocs\ECL\resources\views/E-Leave/self-leave.blade.php ENDPATH**/ ?>